import javax.microedition.lcdui.*;
import javax.microedition.rms.*;
import java.io.*;

class recordStores {
 private RecordStore rs=null;
 private String name;

 public recordStores (String name) {
  try {
   this.name = name;
   rs = null;
   rs = RecordStore.openRecordStore (name,true);
  }
  catch (RecordStoreFullException e) { rs=null; }
  catch (RecordStoreNotOpenException e) { rs=null; }
  catch (RecordStoreException e) { rs=null; } 
 }

 public int getNumRecords () {
  if (rs!=null) {
   try {
    return rs.getNumRecords ();
   }
   catch (RecordStoreNotOpenException e) { return 0; }
   catch (RecordStoreException e) { return 0; }
  }
  else return 0;
 }

 public String getRecord (int n) {
  String s=null;
  if (rs!=null) {
   try {
    byte[] arrData = rs.getRecord(n);
    ByteArrayInputStream bytes = new ByteArrayInputStream(arrData, 0, rs.getRecordSize(n));
    DataInputStream dis = new DataInputStream(bytes);
    s=dis.readUTF();
   }
   catch (IOException ioe) { return null; }        
   catch (RecordStoreException ex) { return null; }
   return s;
  }
  else return null;
 }

 public boolean setRecord (int n,String s) {
  if (rs!=null) {
   ByteArrayOutputStream bytes = new ByteArrayOutputStream();
   DataOutputStream dos = new DataOutputStream (bytes);
   try {   
    dos.writeUTF(s);
    rs.setRecord(n, bytes.toByteArray(), 0, bytes.toByteArray().length);
   }
   catch (IOException ioe) { return false;  }
   catch (InvalidRecordIDException ridex) {
    try {
     rs.addRecord (bytes.toByteArray(), 0, bytes.toByteArray().length);            
    }              
    catch (RecordStoreException ex) { return false; }
   } 
   catch (RecordStoreException ex) { return false; }
   return true;
  } 
  else return false;
 }

 public boolean closeRecords() {
  if (rs!=null) {
   try {
    rs.closeRecordStore();      
    rs=null;
   }
   catch (RecordStoreException ex) { return false; }
   return true;
  }
  else return false;
 }

 public boolean deleteRecords () {
  if (rs!=null) {
   try {
    closeRecords ();
    rs = null;
    RecordStore.deleteRecordStore (name);
   }
   catch (RecordStoreException ex) { return false; }
   return true;
  }
  else return false;
 }
 
}