import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;

public class midlet extends MIDlet implements CommandListener { 
 public Command 
  GO_CMD = new Command(Locale.GO_CMD, Command.EXIT, 2),
  OK_CMD = new Command(Locale.OK_CMD, Command.ITEM, 2),
  ADD_CMD = new Command(Locale.ADD_CMD, Command.ITEM, 2),
  BACK_CMD = new Command(Locale.BACK_CMD, Command.BACK, 1),
  DELETE_CMD = new Command(Locale.DELETE_CMD, Command.ITEM, 2),
  EXIT_CMD = new Command(Locale.EXIT_CMD, Command.EXIT, 2),
  CHANGE_CMD = new Command(Locale.CHANGE_CMD, Command.ITEM, 3),
  PASSWORD_CMD = new Command(Locale.PASSWORD_CMD, Command.ITEM, 3);
 public Image [] icons = { null,null,null,null };
 public List mainMenu=null;
 private boolean isStarted = false;
 private options options;
 private records records;

 public midlet () {
  for (int i=0; i<4; i++) {
   try {
    icons[i] = Image.createImage("/"+i+".png"); 
   }
   catch (java.io.IOException e) {}
  }
  mainMenu = new List(Locale.MAIN_HDR, Choice.IMPLICIT, Locale.mainMenu, icons);
  mainMenu.addCommand (EXIT_CMD);
  mainMenu.setCommandListener(this);
 }

 protected void destroyApp(boolean unconditional) {
  mainMenu = null;
  if (records.changed==true) records.write ();
  records.close ();
  if (options.changed==true) options.write ();
  options.close ();
 }

 protected  void pauseApp() { }

 protected void startApp() {
  if (isStarted==true) { return; }
  options = new options ("alcometr_options");
  boolean t = options.read ();
  records = new records ("alcometr_records");
  records.read ();
  if (t==false) {
   new optionsForm (this,mainMenu,true);
  }
  else {
   if (options.password.length()>0) {
    new checkForm (this,mainMenu);
   }
   else {
    checkdate();
   }
  }
  isStarted=true;
 }

 public void checkdate () {
  mathFunc mathFunc = new mathFunc ();
  long now = mathFunc.getTime();
  long date0=options.date0;
  if (now<date0) {
   new infoForm (Locale.ERROR_HDR, Locale.MSG_BADTIME, this, mainMenu);
  }
  else {
   Display.getDisplay(this).setCurrent (mainMenu);
  }
 }

 public void commandAction(Command c, Displayable d) {
  if (c==List.SELECT_COMMAND) {
   int selected = mainMenu.getSelectedIndex ();
   switch (selected) {
    case 0:
     new listForm (this, mainMenu, records);
    break;
    case 1:
     new optionsForm (this, mainMenu, false);
    break;
    case 2:
     mathFunc mathFunc = new mathFunc ();
     String s = Locale.START_DATE_MSG + mathFunc.getDateStr(options.date0) +
      Locale.SPIRIT_MSG+ options.all + Locale.SPIRIT_SIGN +
      Locale.DAILY_MSG + mathFunc.oCut2(Double.toString(mathFunc.getDaily()))+Locale.SPIRIT_SIGN +
      Locale.RATING_MSG + mathFunc.getRating();
     new infoForm (Locale.STAT_CMD,s,this, mainMenu);
    break;
    case 3:
     new infoForm (Locale.ABOUT_CMD, Locale.MSG_ABOUT, this, mainMenu);
    break;
   }
  }
  else if (c==EXIT_CMD) {
   mainMenu.setTitle (Locale.END_HDR);
   exitMIDlet ();
  }
 }

 public void error (String msg, Displayable parent) { 
  Alert a = new Alert(Locale.ERROR_HDR, msg, null, AlertType.ERROR);
  a.setTimeout(Alert.FOREVER);
  Display.getDisplay(this).setCurrent(a, parent);
 }

 public void message (String msg, Displayable parent) { 
  Alert a = new Alert(Locale.MSG_HDR, msg, null, AlertType.INFO);
  a.setTimeout(Alert.FOREVER);
  Display.getDisplay(this).setCurrent(a, parent);
 }

 public void exitMIDlet() {
  destroyApp(true);
  notifyDestroyed();
 }

}
