import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import java.io.*;
import java.util.*;

public class midlet extends MIDlet implements CommandListener, Receiver { 
 Form mainMenu;
 DateField date;
 Calendar now;
 String fileName;
 static Command 
  QUIT_CMD = new Command(Locale.EXIT_CMD, Command.EXIT, 2),
  BACK_CMD = new Command(Locale.BACK_CMD, Command.BACK, 2),
  LAST_CMD = new Command(Locale.LAST_CMD, Command.BACK, 2),
  ABOUT_CMD = new Command(Locale.ABOUT_CMD, Command.BACK, 2),
  DO_CMD = new Command(Locale.DO_CMD, Command.ITEM, 1);

 public midlet () {
  mainMenu = new Form (Locale.MAIN_HDR);
  date= new DateField (Locale.DATEFIELD_HDR,DateField.DATE);
  now=Calendar.getInstance();
  date.setDate(now.getTime());
  mainMenu.append (date);
  mainMenu.addCommand(DO_CMD);
  mainMenu.addCommand(LAST_CMD);
  mainMenu.addCommand(ABOUT_CMD);
  mainMenu.addCommand(QUIT_CMD);
 }

 protected void destroyApp(boolean unconditional) {
  mainMenu = null;
 }    

 protected  void pauseApp() { }

 protected void startApp() {
  Display.getDisplay(this).setCurrent(mainMenu);
  mainMenu.setCommandListener(this);
 }

 String oNum2 (int d) { return (d<10? "0"+d : ""+d); }

 public void commandAction(Command c, Displayable d) {
  if (c == QUIT_CMD) {
   destroyApp(true);
   notifyDestroyed();
  } 
  else if (c == DO_CMD) {
   Date dt=date.getDate ();
   now=Calendar.getInstance();
   now.setTime (dt);
   fileName=""+oNum2(now.get(Calendar.MONTH)+1)+oNum2(now.get (Calendar.DAY_OF_MONTH));
   mainMenu.setTitle(Locale.WAIT_HDR);
   new InternetConnection(Locale.URL + fileName + ".txt", this);
  }
  else if (c == LAST_CMD) {
   recordStores rs = new recordStores ();
   int n = rs.getNumRecords ();
   if (n==1) {
    String s=null;
    s=rs.getRecord (1);
    if (s!=null) {
     new FoundBox (Locale.LAST_CMD,this,mainMenu,s);
    }
    else error (Locale.NODATA_MSG);
    rs.closeRecords ();
   }
   else error (Locale.NODATA_MSG);
  }
  else if (c == ABOUT_CMD) {
   String s = "HTTP-      , , , .\n      ''    (    CSD-Internet  GPRS-Internet,    GPRS-WAP!).\n      .      ''.\n   ,          .\n(C) PerS, pers@mail.ru";
   new FoundBox (Locale.ABOUT_CMD,this,mainMenu,s);   
  }
 }

 public void received(String url, byte[] data, int len) { 
  mainMenu.setTitle(Locale.MAIN_HDR);  
  String hdr = "" + now.get (Calendar.DAY_OF_MONTH) + " " + Locale.Monthes [now.get(Calendar.MONTH)]; 
  char [] chars = new char [len]; 
  byte b;
  for (int i=0; i<len; i++) {
   b = data[i];
   chars[i] = (char)(b < 0 ? b == -88 ? 0x401 : b == -72 ? 0x451 : (0x400 | ((b & 0x7f) - 0x30)) : b);
  }
  String dataString = new String (chars);
  recordStores rs = new recordStores ();
  if (rs.setRecord (1,hdr + "\n" + dataString)==false) error (Locale.NOSAVE_MSG);
  rs.closeRecords ();
  new FoundBox(hdr, this, mainMenu, dataString);
 }

 public void failure(String url) { 
  mainMenu.setTitle(Locale.MAIN_HDR);
  error (Locale.FAILURE_MSG);
 }

 void error(String msg) { 
  Alert a = new Alert(Locale.ERROR_HDR, msg, null, AlertType.ERROR);
  a.setTimeout(Alert.FOREVER);
  Display.getDisplay(this).setCurrent(a, mainMenu);
 }

}
